CREATE TABLE `admins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `admins` (`id`, `username`, `password`, `email`) VALUES
(1, 'admin', '$2y$10$placeholderpasswordhash', 'admin@example.com');

CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(255) NOT NULL,
  `setting_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `settings` (`setting_key`, `setting_value`) VALUES
('app_name', 'SMIFTY PAY'),
('app_logo', ''),
('app_favicon', ''),
('currency_symbol', '৳'),
('currency_code', 'BDT'),
('webhook_secret_key', 'replace_this_with_a_real_secret_key');

CREATE TABLE `sms_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entry_type` varchar(50) DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `sim_slot` varchar(20) DEFAULT NULL,
  `mobile_number` varchar(50) DEFAULT NULL,
  `trx_id` varchar(100) DEFAULT NULL,
  `amount` decimal(10,2) DEFAULT NULL,
  `balance` decimal(10,2) DEFAULT NULL,
  `status` enum('verified','unverified','failed') NOT NULL DEFAULT 'unverified',
  `received_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `raw_sms` TEXT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trx_id` (`trx_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
